-- MySQL dump 10.8
-- ------------------------------------------------------
-- Server version	4.1.7

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE="NO_AUTO_VALUE_ON_ZERO" */;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `customerId` smallint(6) NOT NULL auto_increment,
  `customerName` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`customerId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `customers`
--


/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
LOCK TABLES `customers` WRITE;
INSERT INTO `customers` VALUES (1,'ABC Inc.'),(2,'Zee Corp.'),(3,'PQW Consulting Group'),(4,'Big Company plc');
UNLOCK TABLES;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;

--
-- Table structure for table `facilities`
--

DROP TABLE IF EXISTS `facilities`;
CREATE TABLE `facilities` (
  `facilityId` smallint(6) NOT NULL auto_increment,
  `FK_customerId` smallint(6) default NULL,
  `facilityName` varchar(255) NOT NULL default '',
  `facilityAddress` varchar(255) NOT NULL default '',
  `facilityCity` varchar(100) NOT NULL default '',
  `facilityState` char(2) NOT NULL default '',
  `facilityPinCode` varchar(10) NOT NULL default '',
  `facilityTel` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`facilityId`),
  KEY `FK_customerId` (`FK_customerId`),
  KEY `facilityState` (`facilityState`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `facilities`
--


/*!40000 ALTER TABLE `facilities` DISABLE KEYS */;
LOCK TABLES `facilities` WRITE;
INSERT INTO `facilities` VALUES (1,1,'Head Office','24 Wildgreen Street','Los Angeles','CA','84828','234-567-0890'),(2,1,'Texas Accounting Branch','17 Boingo Towers','Houston','TX','34738','567-891-2345'),(3,1,'HR Section','25A Underten Street','Houston','TX','34768','567-892-3456'),(4,2,'Head Office','76 Dreed Street','Miami','FL','36279','246-802-4680'),(5,4,'Operations','45, Ingerstrasse Street','Boston','MA','12389','658-436-6362'),(6,4,'Accounting','9 Tigley Court','New York','NY','84932','623-234-7299'),(7,3,'Main Office','12C Empryton Road','New York','NY','35653','123-098-7654');
UNLOCK TABLES;
/*!40000 ALTER TABLE `facilities` ENABLE KEYS */;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `orderId` smallint(6) NOT NULL auto_increment,
  `FK_facilityId` smallint(6) NOT NULL default '0',
  `FK_productId` smallint(6) NOT NULL default '0',
  `orderDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `orderQuantity` int(11) NOT NULL default '0',
  PRIMARY KEY  (`orderId`),
  KEY `FK_facilityId` (`FK_facilityId`),
  KEY `FK_productId` (`FK_productId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `orders`
--


/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
LOCK TABLES `orders` WRITE;
INSERT INTO `orders` VALUES (1,4,3,'2003-01-02 11:17:07',10),(2,4,2,'2003-07-06 12:18:09',25),(3,2,2,'2003-07-10 18:45:59',5),(4,3,3,'2003-08-15 06:30:09',3),(5,3,1,'2003-08-15 16:17:18',5),(6,1,3,'2004-03-12 11:23:56',7),(7,4,3,'2003-01-02 00:00:00',12),(8,3,1,'2004-04-22 22:13:46',1),(9,2,2,'2004-06-29 15:27:08',20),(10,5,4,'2004-06-19 19:10:00',20),(11,7,4,'2004-06-11 17:39:04',35),(12,7,3,'2004-05-13 13:12:11',2),(13,1,2,'2004-02-14 15:32:26',4);
UNLOCK TABLES;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `productId` smallint(6) NOT NULL auto_increment,
  `productDesc` varchar(255) NOT NULL default '',
  `productUnitPrice` decimal(5,2) NOT NULL default '0.00',
  PRIMARY KEY  (`productId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `products`
--


/*!40000 ALTER TABLE `products` DISABLE KEYS */;
LOCK TABLES `products` WRITE;
INSERT INTO `products` VALUES (1,'Power drill','59.99'),(2,'Electric kettle','13.50'),(3,'Lawn mower','45.00'),(4,'Electronic tape measure','20.00'),(5,'Alarm clock','9.99'),(6,'Toaster','29.99');
UNLOCK TABLES;
/*!40000 ALTER TABLE `products` ENABLE KEYS */;

--
-- Table structure for table `products_taxes`
--

DROP TABLE IF EXISTS `products_taxes`;
CREATE TABLE `products_taxes` (
  `FK_productId` smallint(6) NOT NULL default '0',
  `FK_taxId` smallint(6) NOT NULL default '0',
  PRIMARY KEY  (`FK_productId`,`FK_taxId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `products_taxes`
--


/*!40000 ALTER TABLE `products_taxes` DISABLE KEYS */;
LOCK TABLES `products_taxes` WRITE;
INSERT INTO `products_taxes` VALUES (1,1),(2,1),(3,1),(3,3),(4,1),(4,3),(4,4),(6,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `products_taxes` ENABLE KEYS */;

--
-- Table structure for table `taxes`
--

DROP TABLE IF EXISTS `taxes`;
CREATE TABLE `taxes` (
  `taxId` smallint(6) NOT NULL auto_increment,
  `taxDesc` varchar(255) NOT NULL default '',
  `taxPercent` decimal(4,2) NOT NULL default '0.00',
  PRIMARY KEY  (`taxId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `taxes`
--


/*!40000 ALTER TABLE `taxes` DISABLE KEYS */;
LOCK TABLES `taxes` WRITE;
INSERT INTO `taxes` VALUES (1,'Sales Tax','10.00'),(2,'Service Tax','8.00'),(3,'Excise','5.00'),(4,'Customs','25.00');
UNLOCK TABLES;
/*!40000 ALTER TABLE `taxes` ENABLE KEYS */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;

