<?
/*
All source code copyright and proprietary Melonfire, 2001. All content, brand names and trademarks copyright and proprietary Melonfire, 2001. All rights reserved. Copyright infringement is a violation of law.

This source code is provided with NO WARRANTY WHATSOEVER. It is meant for illustrative purposes only, and is NOT recommended for use in production environments. 

Read more articles like this one at http://www.melonfire.com/community/columns/trog/ and http://www.melonfire.com/
*/

// functions.php - useful functions

// function to format DATE values
function fixDate($val)
{
// split it up into components
$datearr = explode("-", $val);
// create a timestamp with mktime(), format it with date()
return date("d M Y", mktime(0, 0, 0, $datearr[1], $datearr[2], $datearr[0]));
}

// generate three list boxes for d-m-y selection
function generateDateSelector($prefix="")
{
// month array
$monthArray = array("", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");

// get current year, month and date
$arr = getdate(mktime());
$currYear = $arr["year"];
$currMonth = $arr["mon"];
$currDay = $arr["mday"];

// generate date drop-down
echo "<select name=" . $prefix . "d>";
	for ($x=1; $x<=31; $x++) 
	{ 
	$str = "<option value=" . sprintf("%02d", $x) . "";
		if ($x == $currDay)
		{
		$str .= " selected";
		}
	$str .= ">" . sprintf("%02d", $x) . "</option>"; 
	echo $str;
	} 
echo "</select>";

// generate month drop-down
echo "<select name=" . $prefix . "m>";
	for ($x=1; $x<=12; $x++) 
	{ 
	$str = "<option value=" . sprintf("%02d", $x) . "";
		if ($x == $currMonth)
		{
		$str .= " selected";
		}
	$str .= ">" . $monthArray[$x] . "</option>"; 
	echo $str;
	} 
echo "</select>";

// generate year drop-down
echo "<select name=" . $prefix . "y>";
	for ($x=$currYear; $x<($currYear+5); $x++)
	{
	$str = "<option value=$x";
		if ($x == $currYear)
		{
		$str .= " selected";
		}
	$str .= ">" . sprintf("%04d", $x) . "</option>";
	echo $str;
	}
echo "</select>";
}

?>