
#include <stdio.h>
#include <mysql.h>

int main(int argc, char *argv[])
{

    /* declare structures and variables */
    char query[255];        /* query string */
    int i, j, h, count;     /* loop counter variables */
    MYSQL mysql;            /* MYSQL struct */
    MYSQL_RES *result;      /* pointer to result set struct */
    MYSQL_ROW row;          /* row struct */
    MYSQL_FIELD *field;     /* pointer to field struct */

    /* check for command-line arguments */
    /* if no arguments are passed, count is 1 */
    /* for empty password, pass "" */
    if (argc != 4)
    {
            printf ("Usage: %s <host> <user> <password>\n", argv[0]);
            exit();
    }

    /* initialize MYSQL structure */
    mysql_init(&mysql);

    /* connect to database with command-line arguments */
    if (!(mysql_real_connect(&mysql, argv[1], argv[2], argv[3], NULL, 0, 
NULL, 0)))
    {
            fprintf(stderr, "Error in connection: %s\n", mysql_error(&mysql));
	    exit();
    }

	/* loop and display prompt until "exit" */
	for( ;; )
	{
	        /* ask for query */
	        printf("query? ");
	        gets(query);
	        
	        /* if "exit", break out of loop */
		  if (strcmp(query,"exit") == 0)
	        {
	                break;
	        }
	
	        /* execute query */
	        /* if error, display error message */
	        /* else check the type of query and handle appropriately */
	        if (mysql_query(&mysql, query) != 0)
	        {
	                fprintf(stderr, "Error in query: %s\n", 
mysql_error(&mysql));
	        }
	        else
	        {
	                if (result = mysql_store_result(&mysql))
	                {
	                        /* SELECT query */
	                        /* get some information on result set */
	                        int numRecords = mysql_num_rows(result);
	                        int numFields = mysql_num_fields(result);
	
	                        /* print field names */
	                        for (h = 0; h < numFields; h++)
	                        {
	                                field = mysql_fetch_field(result);
	                                printf("[%s]", field->name);
	                                (h != (numFields-1)) ? printf(", ") : 
printf("\n");
	                        }
	
	                        /* process result set records */
	                        for (i = 0; i < numRecords; i++)
	                        {
	                                row = mysql_fetch_row(result);
	                                for (j = 0; j < numFields; j++)
	                                {
	                                        fprintf(stdout, "%s", row[j]);
	                                        (j != (numFields-1)) ? 
printf(", ") : printf("\n");
	                                }
	                        }
	                        fprintf(stdout, "** Query successful, %d rows retrieved **\n", numRecords);
	                        mysql_free_result(result);
	                }
	                else
	                {
	                        if (mysql_field_count(&mysql) == 0)
	                        {
	                                /* non-SELECT query */
	                                /* show number of affected rows */
	                                fprintf(stdout, "** Query successful, %d rows affected **\n", mysql_affected_rows(&mysql));
	                        }
	                        else
	                        {
	                                /* else print error */
	                                fprintf(stderr, "Error in reading result set: %s\n", mysql_error(&mysql));
	                        }
	                }
	        }
	}
	
	/* clean up */
	mysql_close(&mysql);
}
