
#include <stdio.h>
#include <mysql.h>

int main ()
{

   /* declare variables */
   FILE *fp;  /* file pointer */
   char lineBuffer[1000]; /* line buffer */
   const char *sep = ":"; /* field separator in config file */
   char *prev_p;
   long next_p;

   char host[100];   /* database access varianbles */
   char user[50];
   char pass[50];
   char db[50];

   /* open configuration file */
   fp = fopen ("expenses.conf", "r");

   if (fp != NULL)
   {
      /* initialisation */
      memset (lineBuffer, '\0', sizeof(lineBuffer));
      memset (host, '\0', sizeof(host));
      memset (user, '\0', sizeof(user));
      memset (pass, '\0', sizeof(pass));
      memset (db, '\0', sizeof(db));

      /* split by separator */
      /* read configuration data into variables */
      fscanf (fp, "%s", lineBuffer);
      if (strlen(lineBuffer) != 0)
      {
         prev_p = lineBuffer;
         strncpy(host, prev_p, next_p = strstr (prev_p, sep) - prev_p);

         prev_p =  (char *) ((long) prev_p + next_p + 1);
         strncpy(user, prev_p, next_p = strstr (prev_p, sep) - prev_p);
         prev_p =  (char *) ((long) prev_p + next_p + 1);
         strncpy(pass, prev_p, next_p = strstr (prev_p, sep) - prev_p);
         prev_p =  (char *) ((long) prev_p + next_p + 1);
         strcpy(db, prev_p);
      }
      else
      {
         fprintf(stderr, "Error: no data in configuration file\n");
         exit();
      }

      /* close file */
      fclose (fp);
   }
   else
   {
      fprintf(stderr, "Error: unable to read configuration file\n");
      exit();
   }

   /* declare structures and variables */
   int choice;         /* menu selection */
   MYSQL mysql;        /* MYSQL struct */
   MYSQL_RES *result;  /* pointer result set struct */
   MYSQL_ROW row;      /* row struct */
   MYSQL_FIELD *field; /* pointer to field struct */

   /* initialize MYSQL structure */
   mysql_init(&mysql);

   /* connect to database with configuration arguments */
   if (!(mysql_real_connect(&mysql, host, user, pass, db, 0, NULL, 0)))
   {
      fprintf(stderr, "Error in connection: %s\n", mysql_error(&mysql));
      exit();
   }

   /* print menu */
   printf("\n");
   printf("[1] View expense totals\n");
   printf("[2] Add expense item\n");
   printf("[3] Quit\n");
   printf("\n");
   printf("Select an option from the list above: ");

   /* wait for user input */
   scanf("%d", &choice);

   printf("\n");

   /* based on user choice, perform actions */
   if (choice == 1)
   {

      /* perform query to get totals in each category */
      /* and print report */
      if (mysql_query(&mysql, "SELECT cname, SUM(amt) FROM categories, data WHERE categories.cid = data.cid GROUP BY cname") != 0)
      {
         fprintf(stderr, "Error in query: %s\n", mysql_error(&mysql));
         mysql_close(&mysql);
         exit();
      }
      else
      {
         /* check to see if result set */
         /* iterate over rows and print in category = total format */
	   if (result = mysql_store_result(&mysql))
         {
             int numRecords = mysql_num_rows(result);
             int i;
             for (i = 0; i < numRecords; i++)
             {
                row = mysql_fetch_row(result);
                printf ("%s = %s\n", row[0], row[1]);
             }
             printf("\n");
             mysql_free_result(result);
         }
         else
	   {
            fprintf(stderr, "Error in reading result set: %s\n", 
mysql_error(&mysql));
            mysql_close(&mysql);
            exit();
	   }
      }
   }
   else if (choice == 2)
   {
      float amt;           /* variables for insert */
      int cid;
      char date[10];

      char query[1024];   /* query string */
      int i;              /* loop counter */

      /* ask user to enter date */
      /* if error in format, exit */
	printf("Enter date (yyyy-mm-dd): ");
      if (!scanf("%s", &date))
      {
         fprintf(stderr, "Error in input: unexpected input value\n");
         mysql_close(&mysql);
         exit();
      }
      
      /* ask user to enter amount */
      /* if error in format, exit */
      printf("Enter amount: ");
      if (!scanf("%f", &amt))
      {
         fprintf(stderr, "Error in input: unexpected input value\n");
         mysql_close(&mysql);
         exit();
      }

      /* ask user to enter category */
      /* retrieve list of categories/IDs from database */
      /* if error in format, exit */
      printf("Enter category number (");

      /* get category numbers */
      if (mysql_query(&mysql, "SELECT cid, cname FROM categories") != 0)
      {
         fprintf(stderr, "Error in query: %s\n", mysql_error(&mysql));
         mysql_close(&mysql);
         exit();
      }
      else
      {
         /* print category names and numbers */
         if (result = mysql_store_result(&mysql))
         {
            int numRecords = mysql_num_rows(result);
            int i;
            for (i = 0; i < numRecords; i++)
            {
               row = mysql_fetch_row(result);
               printf (" %s=%s ", row[0], row[1]);
            }
            mysql_free_result(result);
         }
         else
         {
            fprintf(stderr, "Error in reading result set: %s\n", 
mysql_error(&mysql));
            mysql_close(&mysql);
            exit();
         }
      }
      printf("): ");
      if (!scanf("%d", &cid))
      {
         fprintf(stderr, "Error in input: unexpected input value\n");
         exit();
      }


      /* once all the data has come in */
      /* create query string */
      sprintf(query, "INSERT INTO data (date, amt, cid) VALUES ('%s', '%f', '%d')", date, amt, cid);

      /* perform insert */
      if (mysql_query(&mysql, query) != 0)
      {
         fprintf(stderr, "Error in query: %s\n", mysql_error(&mysql));
         mysql_close(&mysql);
         exit();
      }
      printf("\n");

   }

   /* close connection */
   mysql_close(&mysql);
   exit();

}
