#
# Chapter 6
#

CREATE TABLE `toys` (
  `id` int(10) unsigned NOT NULL default '0',
  `item` varchar(255) NOT NULL default '',
  `ctm` decimal(5,2) unsigned NOT NULL default '0.00',
  `ctr` decimal(5,2) NOT NULL default '0.00',
  `ctc` decimal(5,2) unsigned NOT NULL default '0.00',
  `quantity` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `toys`
#

INSERT INTO `toys` VALUES (1, 'Huggy bear', '5.00', '7.40', '9.90', 300);
INSERT INTO `toys` VALUES (2, 'Colouring book', '3.00', '5.00', '7.99', 2000);
INSERT INTO `toys` VALUES (3, 'Board game', '12.00', '20.00', '39.90', 1430);
INSERT INTO `toys` VALUES (4, 'Activity CD-ROM', '2.00', '6.00', '17.49', 3780);

#
# Table structure for table `racedata`
#

CREATE TABLE `racedata` (
  `name` varchar(255) NOT NULL default '0',
  `total` tinyint(4) NOT NULL default '0',
  `win` tinyint(4) NOT NULL default '0',
  `place` tinyint(4) NOT NULL default '0',
  `unplaced` tinyint(4) NOT NULL default '0'
) TYPE=MyISAM;

#
# Dumping data for table `racedata`
#

INSERT INTO `racedata` VALUES ('Stormtrooper', 50, 4, 13, 9);
INSERT INTO `racedata` VALUES ('VioletDaisy', 9, 4, 5, 0);
INSERT INTO `racedata` VALUES ('King William', 33, 11, 15, 4);
INSERT INTO `racedata` VALUES ('Remuneration', 127, 35, 56, 22);
INSERT INTO `racedata` VALUES ('Pop Princess', 79, 4, 14, 43);
INSERT INTO `racedata` VALUES ('Superman', 43, 0, 6, 11);
INSERT INTO `racedata` VALUES ('Baby Boo', 67, 56, 10, 1);

#
# Table structure for table `employees`
#

CREATE TABLE `employees` (
  `id` smallint(6) NOT NULL default '0',
  `lname` varchar(255) NOT NULL default '',
  `fname` varchar(255) NOT NULL default '',
  `age` tinyint(4) NOT NULL default '0',
  `sex` char(1) NOT NULL default '',
  `department` varchar(255) NOT NULL default '',
  `country` char(2) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `employees`
#

INSERT INTO `employees` VALUES (54, 'Doe', 'John', 27, 'M', 'Engineering', 'US');
INSERT INTO `employees` VALUES (127, 'Jones', 'Sue', 31, 'F', 'Finance', 'UK');
INSERT INTO `employees` VALUES (113, 'Woo', 'David', 26, 'M', 'Administration', 'CN');
INSERT INTO `employees` VALUES (175, 'Thomas', 'James', 34, 'M', 'Finance', 'US');
INSERT INTO `employees` VALUES (168, 'Kent', 'Jane', 29, 'F', 'Administration', 'US');
INSERT INTO `employees` VALUES (12, 'Kamath', 'Ravina', 35, 'F', 'Finance', 'IN');

#
# Chapter 7
#

#
# Table structure for table `marks`
#

CREATE TABLE `marks` (
  `id` tinyint(4) NOT NULL auto_increment,
  `fname` varchar(50) NOT NULL default '',
  `lname` varchar(50) NOT NULL default '',
  `math` int(11) NOT NULL default '0',
  `sci` int(11) NOT NULL default '0',
  `lit` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=7 ;

#
# Dumping data for table `marks`
#

INSERT INTO `marks` VALUES (1, 'John', 'Doe', 36, 73, 34);
INSERT INTO `marks` VALUES (2, 'Sarah', 'Short', 23, 67, 55);
INSERT INTO `marks` VALUES (3, 'Joe', 'Cool', 75, 82, 89);
INSERT INTO `marks` VALUES (4, 'Mark', 'Wumba', 58, 72, 15);
INSERT INTO `marks` VALUES (5, 'Tom', 'Thumb', 0, 12, 0);

CREATE TABLE `birthdays` (
  `name` varchar(50) NOT NULL default '',
  `dob` date NOT NULL default '0000-00-00'
) TYPE=MyISAM;

#
# Dumping data for table `birthdays`
#

INSERT INTO `birthdays` VALUES ('raoul', '1978-06-04');
INSERT INTO `birthdays` VALUES ('luis', '1965-11-17');
INSERT INTO `birthdays` VALUES ('larry', '1971-08-19');
INSERT INTO `birthdays` VALUES ('moe', '1992-01-23');


#
# Table structure for table `library`
#

CREATE TABLE `library` (
  `member` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `check_out_date` date NOT NULL default '0000-00-00',
  `check_in_date` date NOT NULL default '0000-00-00'
) TYPE=MyISAM;

#
# Dumping data for table `library`
#

INSERT INTO `library` VALUES ('joe', 'The Phantom Menace', '2002-09-11', '2002-09-14');
INSERT INTO `library` VALUES ('john', 'Cape Fear', '2002-07-15', '2002-07-21');
INSERT INTO `library` VALUES ('johann', 'Casper', '2003-01-01', '2003-01-05');
INSERT INTO `library` VALUES ('mark', 'The Godfather', '2000-08-17', '2000-09-16');
INSERT INTO `library` VALUES ('jthomas', 'Who Killed Roger Rabbit?', '2003-11-17', '2003-11-25');

#
# Table structure for table `users`
#

CREATE TABLE `users` (
  `uid` tinyint(4) NOT NULL default '0',
  `uname` char(8) NOT NULL default '',
  `upass` char(15) NOT NULL default ''
) TYPE=MyISAM;

#
# Chapter 8
#

#
# Table structure for table `old`
#

CREATE TABLE `old` (
  `email` varchar(255) NOT NULL default '',
  `day` char(2) NOT NULL default '',
  `month` char(2) NOT NULL default '',
  `year` varchar(4) NOT NULL default '',
  `hour` char(2) NOT NULL default '',
  `min` char(2) NOT NULL default '',
  PRIMARY KEY  (`email`)
) TYPE=MyISAM;

#
# Dumping data for table `old`
#

INSERT INTO `old` VALUES ('mark@some.domain.net', '15', '03', '1999', '13', '42');
INSERT INTO `old` VALUES ('armyguy@free.mail.service.com', '31', '12', '2001', '19', '59');
INSERT INTO `old` VALUES ('debuz@some.unknown.tld', '08', '11', '1996', '03', '37');

#
# Table structure for table `new`
#

CREATE TABLE `new` (
  `email` varchar(255) NOT NULL default '',
  `ts` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`email`)
) TYPE=MyISAM;

#
# Dumping data for table `new`
#

INSERT INTO `new` VALUES ('mark@some.domain.net', '1999-03-15 13:42:00');
INSERT INTO `new` VALUES ('armyguy@free.mail.service.com', '2001-12-31 19:59:00');
INSERT INTO `new` VALUES ('debuz@some.unknown.tld', '1996-11-08 03:37:00');

#
# Table structure for table `library`
#

CREATE TABLE `movies` (
  `title` varchar(255) NOT NULL default '',
) TYPE=MyISAM;

#
# Dumping data for table `movies`
#

INSERT INTO `movies` VALUES ('The Phantom Menace');
INSERT INTO `movies` VALUES ('Cape Fear');
INSERT INTO `movies` VALUES ('Casper');
INSERT INTO `movies` VALUES ('The Godfather');
INSERT INTO `movies` VALUES ('Who Killed Roger Rabbit?');

#
# Chapter 9
#

#
# Table structure for table `addressbook`
#

CREATE TABLE `addressbook` (
  `fname` char(255) default NULL,
  `lname` char(255) default NULL,
  `phone` char(255) NOT NULL default '',
  `fax` char(255) default NULL,
  `email` char(255) default NULL
) TYPE=MyISAM;

#
# Dumping data for table `addressbook`
#

INSERT INTO `addressbook` VALUES ('Cathy', 'Cat', '', NULL, 'cathy@cat.nip');
INSERT INTO `addressbook` VALUES ('Polly', 'Parrot', '', NULL, 'polly@talk.to.me');
INSERT INTO `addressbook` VALUES ('Harry', 'Hedgehog', '', NULL, 'harry@prickles.tld');
INSERT INTO `addressbook` VALUES ('David', 'Dog', '', NULL, 'woof@doghouse');

CREATE TABLE `stocks` (
  `symbol` char(4) character set latin1 NOT NULL default '',
  `price` int(4) NOT NULL default '0',
  `quantity` int(4) NOT NULL default '0'
) TYPE=MyISAM;

#
# Dumping data for table `stocks`
#

INSERT INTO `stocks` VALUES ('ABCD', 100, 4500);
INSERT INTO `stocks` VALUES ('HYDH', 2000, 29);
INSERT INTO `stocks` VALUES ('UGTS', 25, 67);

#
# Table structure for table `forums`
#

CREATE TABLE `forums` (
  `name` varchar(150) NOT NULL default '',
  `category` varchar(50) NOT NULL default 'UNIX',
  `postsPerPage` smallint(6) NOT NULL default '15',
  `highlightColor` varchar(10) NOT NULL default 'red'
) TYPE=MyISAM;

#
# Dumping data for table `forums`
#

INSERT INTO `forums` VALUES ('Sendmail', 'UNIX', 15, 'green');
INSERT INTO `forums` VALUES ('Apache', 'UNIX', 15, 'red');
INSERT INTO `forums` VALUES ('Apache', 'UNIX', 15, 'red');

#
# Table structure for table `users`
#

CREATE TABLE users (uid TINYINT(4) NOT NULL AUTO_INCREMENT, 
uname varchar(8) NOT NULL DEFAULT '', upass VARCHAR(15) NOT NULL DEFAULT '', PRIMARY KEY (uid));

INSERT INTO users (uname, upass) VALUES ('jim', PASSWORD('secret'));
INSERT INTO users (uname, upass) VALUES ('sarah', PASSWORD('opensesame'));
INSERT INTO users (uname, upass) VALUES ('tim', PASSWORD('whiteboard'));

#
# Table structure for table `menu`
#

CREATE TABLE `menu` (
  `id` int(8) NOT NULL default '0',
  `label` varchar(255) NOT NULL default '',
  `url` varchar(255) default NULL,
  UNIQUE KEY `id` (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `menu`
#

INSERT INTO `menu` VALUES (1, 'Home', 'home.html');
INSERT INTO `menu` VALUES (2, 'About Us', 'aboutus.html');
INSERT INTO `menu` VALUES (3, 'Services', 'services.html');
INSERT INTO `menu` VALUES (4, 'Contact Us', 'contactus.html');


#
# Table structure for table `accounts`
#

CREATE TABLE `accounts` (
  `accountNumber` bigint(20) NOT NULL default '0',
  `accountName` varchar(255) NOT NULL default '',
  `accountCreatedOn` date NOT NULL default '0000-00-00',
  `accountCreatedAt` varchar(255) NOT NULL default '',
  `accountBalance` float(15,5) NOT NULL default '0.00000',
  PRIMARY KEY  (`accountNumber`)
) TYPE=MyISAM;

#
# Dumping data for table `accounts`
#

INSERT INTO `accounts` VALUES (1265489921, 'James D', '1998-07-29', 'NY', '2346.00000');
INSERT INTO `accounts` VALUES (2147483647, 'Timothy J', '2000-12-12', 'BO', '56347.50000');
INSERT INTO `accounts` VALUES (5739304575, 'Harish K', '1995-09-13', 'NY', '996564.87500');
INSERT INTO `accounts` VALUES (2173467271, 'Kingston X', '1967-09-15', 'MA', '634238.00000');
INSERT INTO `accounts` VALUES (2312934021, 'Sue U', '1998-06-06', 'MA', '34.67000');
INSERT INTO `accounts` VALUES (1248954638, 'Ila T', '2003-08-17', 'CA', '5373.81982');
INSERT INTO `accounts` VALUES (2384371001, 'Anil V', '2001-11-19', 'MA', '72460.00000');
INSERT INTO `accounts` VALUES (9430125467, 'Katrina P', '2003-07-01', 'NY', '100.00000');
INSERT INTO `accounts` VALUES (1890192554, 'Pooja B', '2002-01-23', 'FL', '17337.11914');
INSERT INTO `accounts` VALUES (2388282010, 'Sue U', '1998-03-27', 'BO', '388883.12500');
INSERT INTO `accounts` VALUES (2374845291, 'Jacob N', '2003-05-01', 'NY', '18410.00000');

#
# Chapter 10
#

#
# Table structure for table `categories`
#

CREATE TABLE `categories` (
  `cid` int(8) default NULL,
  `cname` varchar(255) default NULL
) TYPE=MyISAM CHARSET=latin1;

#
# Dumping data for table `categories`
#

INSERT INTO `categories` VALUES (1, 'Sports');
INSERT INTO `categories` VALUES (2, 'Current Affairs');
INSERT INTO `categories` VALUES (3, 'Business');
INSERT INTO `categories` VALUES (4, 'Technology');

#
# Table structure for table `topics`
#

CREATE TABLE `topics` (
  `tid` int(8) default NULL,
  `tname` varchar(255) default NULL,
  `tdate` date NOT NULL default '0000-00-00',
  `cid` int(8) default NULL
) TYPE=MyISAM CHARSET=latin1;

#
# Dumping data for table `topics`
#

INSERT INTO `topics` VALUES (100, 'Probe lands on Mars', '2002-03-19', 4);
INSERT INTO `topics` VALUES (102, 'Stock markets crash', '2002-03-05', 3);
INSERT INTO `topics` VALUES (104, 'War breaks out between men and fish', '2003-08-14', 2);
INSERT INTO `topics` VALUES (106, 'Volcanic eruptions on Pluto', '2003-01-03', 2);
INSERT INTO `topics` VALUES (107, 'Injured football player vows to return', '2003-06-18', 1);
INSERT INTO `topics` VALUES (110, 'Cell phones found to improve cognition among babies', '2003-09-14', 4);
INSERT INTO `topics` VALUES (113, 'Leaders of day-trading scam arrested by FBI', '2002-12-27', 3);

#
# Table structure for table `attributes`
#

CREATE TABLE `attributes` (
  `attribute` varchar(255) character set latin1 default NULL
) TYPE=MyISAM;

#
# Dumping data for table `attributes`
#

INSERT INTO `attributes` VALUES ('eyes');
INSERT INTO `attributes` VALUES ('hair');

#
# Table structure for table `colors`
#

CREATE TABLE `colors` (
  `color` varchar(255) character set latin1 default NULL
) TYPE=MyISAM;

#
# Dumping data for table `colors`
#

INSERT INTO `colors` VALUES ('brown');
INSERT INTO `colors` VALUES ('black');
INSERT INTO `colors` VALUES ('gray');

#
# Table structure for table `sex`
#

CREATE TABLE `sex` (
  `sex` varchar(255) character set latin1 default NULL
) TYPE=MyISAM;

#
# Dumping data for table `sex`
#

INSERT INTO `sex` VALUES ('male');
INSERT INTO `sex` VALUES ('female');

# --------------------------------------------------------

#
# Table structure for table `shape`
#

CREATE TABLE `shape` (
  `shape` varchar(255) character set latin1 default NULL
) TYPE=MyISAM;

#
# Dumping data for table `shape`
#

INSERT INTO `shape` VALUES ('fat');
INSERT INTO `shape` VALUES ('long');
INSERT INTO `shape` VALUES ('thin');
INSERT INTO `shape` VALUES ('short');

#
# Table structure for table `products`
#

CREATE TABLE `products` (
  `productID` int(8) default NULL,
  `productName` varchar(255) character set latin1 default NULL,
  `avgSales` int(8) default NULL
) TYPE=MyISAM;

#
# Dumping data for table `products`
#

INSERT INTO `products` VALUES (1, 'apples', 1400);
INSERT INTO `products` VALUES (2, 'oranges', 2000);
INSERT INTO `products` VALUES (3, 'pineapples', 2500);
INSERT INTO `products` VALUES (4, 'bananas', 1000);


#
# Table structure for table `sales`
#

CREATE TABLE `sales` (
  `id` int(8) default NULL,
  `productID` int(8) default NULL,
  `quantity` int(8) default NULL
) TYPE=MyISAM;

#
# Dumping data for table `sales`
#

INSERT INTO `sales` VALUES (1, 3, 2300);
INSERT INTO `sales` VALUES (2, 2, 1500);
INSERT INTO `sales` VALUES (3, 1, 3400);

#
# Table structure for table `users`
#

CREATE TABLE `users` (
  `uid` int(8) default NULL,
  `name` varchar(255) character set latin1 default NULL
) TYPE=MyISAM;

#
# Dumping data for table `users`
#

INSERT INTO `users` VALUES (100, 'sue');
INSERT INTO `users` VALUES (103, 'harry');
INSERT INTO `users` VALUES (104, 'louis');
INSERT INTO `users` VALUES (107, 'sam');
INSERT INTO `users` VALUES (110, 'james');
INSERT INTO `users` VALUES (111, 'mark');
INSERT INTO `users` VALUES (112, 'rita');

#
# Table structure for table `groups`
#

CREATE TABLE `groups` (
  `gid` int(8) default NULL,
  `name` varchar(255) character set latin1 default NULL
) TYPE=MyISAM;

#
# Dumping data for table `groups`
#

INSERT INTO `groups` VALUES (501, 'authors');
INSERT INTO `groups` VALUES (502, 'actors');
INSERT INTO `groups` VALUES (503, 'musicians');
INSERT INTO `groups` VALUES (504, 'chefs');

#
# Table structure for table `users_groups`
#

CREATE TABLE `users_groups` (
  `gid` int(8) default NULL,
  `uid` int(8) default NULL
) TYPE=MyISAM;

#
# Dumping data for table `users_groups`
#

INSERT INTO `users_groups` VALUES (502, 11);
INSERT INTO `users_groups` VALUES (502, 107);
INSERT INTO `users_groups` VALUES (503, 100);
INSERT INTO `users_groups` VALUES (501, 110);
INSERT INTO `users_groups` VALUES (501, 112);
INSERT INTO `users_groups` VALUES (501, 100);
INSERT INTO `users_groups` VALUES (501, 102);
INSERT INTO `users_groups` VALUES (502, 104);
INSERT INTO `users_groups` VALUES (502, 100);

#
# Table structure for table `menu2`
#

CREATE TABLE `menu` (
  `id` tinyint(3) unsigned NOT NULL auto_increment,
  `link` varchar(255) character set latin1 default NULL,
  `label` varchar(255) character set latin1 NOT NULL default '',
  `parent` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM AUTO_INCREMENT=22 ;

#
# Dumping data for table `menu`
#

INSERT INTO `menu` VALUES (1, 'http://www.melonfire.com/services/', 'Services', 0);
INSERT INTO `menu` VALUES (2, 'http://www.melonfire.com/company/', 'Company', 0);
INSERT INTO `menu` VALUES (3, 'http://www.melonfire.com/mcenter/', 'Media Center', 0);
INSERT INTO `menu` VALUES (4, 'http://www.melonfire.com/account/', 'Your Account', 0);
INSERT INTO `menu` VALUES (5, 'http://www.melonfire.com/community/', 'Community', 0);
INSERT INTO `menu` VALUES (6, 'http://www.melonfire.com/services/content.html', 'For Content Publishers', 1);
INSERT INTO `menu` VALUES (7, 'http://www.melonfire.com/services/sbs.html', 'For Small Businesses', 1);
INSERT INTO `menu` VALUES (8, 'http://www.melonfire.com/company/background.html', 'Background', 2);
INSERT INTO `menu` VALUES (9, 'http://www.melonfire.com/company/clients.html', 'Clients', 2);
INSERT INTO `menu` VALUES (10, 'http://www.melonfire.com/company/addresses.html', 'Addresses', 2);
INSERT INTO `menu` VALUES (11, 'http://www.melonfire.com/company/jobs.html', 'Jobs', 2);
INSERT INTO `menu` VALUES (12, 'http://www.melonfire.com/company/news.php3', 'News', 2);
INSERT INTO `menu` VALUES (13, 'http://www.melonfire.com/mcenter/pr.html', 'Press Releases', 3);
INSERT INTO `menu` VALUES (14, 'http://www.melonfire.com/mcenter/mkit.html', 'Media Kit', 3);
INSERT INTO `menu` VALUES (15, 'http://www.melonfire.com/account/index.html', 'Log In', 4);
INSERT INTO `menu` VALUES (16, 'http://www.melonfire.com/community/columns/', 'Columns', 5);
INSERT INTO `menu` VALUES (17, 'http://www.melonfire.com/community/columns/colophon/', 'Colophon', 16);
INSERT INTO `menu` VALUES (18, 'http://www.melonfire.com/community/columns/cut/', 'Cut', 16);
INSERT INTO `menu` VALUES (19, 'http://www.melonfire.com/community/columns/boombox/', 'Boombox', 16);
INSERT INTO `menu` VALUES (20, 'http://www.melonfire.com/community/columns/thr/', 'The HITG Report', 16);
INSERT INTO `menu` VALUES (21, 'http://www.melonfire.com/community/columns/trog/', 'Trog', 16);

#
# Table structure for table `exchangea`
#

CREATE TABLE `exchangea` (
  `symbol` varchar(255) NOT NULL default '',
  `price` float(6,2) NOT NULL default '0.00'
) TYPE=MyISAM CHARSET=latin1;

#
# Dumping data for table `exchangea`
#

INSERT INTO `exchangea` VALUES ('HDGS', '6.78');
INSERT INTO `exchangea` VALUES ('TDGB', '78.44');
INSERT INTO `exchangea` VALUES ('HDTE', '123.71');
INSERT INTO `exchangea` VALUES ('BGHU', '12.90');
INSERT INTO `exchangea` VALUES ('HTYF', '90.10');
INSERT INTO `exchangea` VALUES ('WERR', '32.91');
INSERT INTO `exchangea` VALUES ('YTEM', '39.65');

#
# Table structure for table `exchangeb`
#

CREATE TABLE `exchangeb` (
  `symbol` varchar(255) NOT NULL default '',
  `price` float(6,2) NOT NULL default '0.00'
) TYPE=MyISAM CHARSET=latin1;

#
# Dumping data for table `exchangeb`
#

INSERT INTO `exchangeb` VALUES ('POYT', '87.10');
INSERT INTO `exchangeb` VALUES ('DFRM', '9.43');
INSERT INTO `exchangeb` VALUES ('HTYF', '89.70');
INSERT INTO `exchangeb` VALUES ('TDGB', '11.80');
INSERT INTO `exchangeb` VALUES ('TDGB', '79.00');

#
# Chapter 11
#

#
# Table structure for table `branches`
#

CREATE TABLE `branches` (
  `bid` int(8) NOT NULL default '0',
  `cid` tinyint(4) NOT NULL default '0',
  `bdesc` varchar(255) NOT NULL default '',
  `bloc` char(3) NOT NULL default ''
) TYPE=MyISAM CHARSET=latin1;

#
# Dumping data for table `branches`
#

INSERT INTO `branches` VALUES (1011, 101, 'Corporate HQ', 'CA');
INSERT INTO `branches` VALUES (1012, 101, 'Accounting Department', 'NY');
INSERT INTO `branches` VALUES (1013, 101, 'Customer Grievances Department', 'KA');
INSERT INTO `branches` VALUES (1041, 104, 'Branch Office (East)', 'MA');
INSERT INTO `branches` VALUES (1042, 104, 'Branch Office (West)', 'CA');
INSERT INTO `branches` VALUES (1101, 110, 'Head Office', 'CA');
INSERT INTO `branches` VALUES (1031, 103, 'N Region HO', 'ME');
INSERT INTO `branches` VALUES (1032, 103, 'NE Region HO', 'CT');
INSERT INTO `branches` VALUES (1033, 103, 'NW Region HO', 'NY');


#
# Table structure for table `branches_services`
#

CREATE TABLE `branches_services` (
  `bid` int(8) NOT NULL default '0',
  `sid` tinyint(4) NOT NULL default '0'
) TYPE=MyISAM CHARSET=latin1;

#
# Dumping data for table `branches_services`
#

INSERT INTO `branches_services` VALUES (1011, 1);
INSERT INTO `branches_services` VALUES (1011, 2);
INSERT INTO `branches_services` VALUES (1011, 3);
INSERT INTO `branches_services` VALUES (1011, 6);
INSERT INTO `branches_services` VALUES (1012, 1);
INSERT INTO `branches_services` VALUES (1013, 5);
INSERT INTO `branches_services` VALUES (1041, 1);
INSERT INTO `branches_services` VALUES (1041, 4);
INSERT INTO `branches_services` VALUES (1042, 1);
INSERT INTO `branches_services` VALUES (1042, 6);
INSERT INTO `branches_services` VALUES (1101, 1);
INSERT INTO `branches_services` VALUES (1031, 2);
INSERT INTO `branches_services` VALUES (1031, 3);
INSERT INTO `branches_services` VALUES (1031, 4);
INSERT INTO `branches_services` VALUES (1032, 3);
INSERT INTO `branches_services` VALUES (1033, 4);


#
# Table structure for table `clients`
#

CREATE TABLE `clients` (
  `cid` tinyint(4) NOT NULL default '0',
  `cname` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`cid`)
) TYPE=MyISAM CHARSET=latin1;

#
# Dumping data for table `clients`
#

INSERT INTO `clients` VALUES (101, 'JV Real Estate');
INSERT INTO `clients` VALUES (102, 'ABC Talent Agency');
INSERT INTO `clients` VALUES (103, 'DMW Trading');
INSERT INTO `clients` VALUES (104, 'Rabbit Foods Inc');
INSERT INTO `clients` VALUES (110, 'Sharp Eyes Detective Agency');

#
# Table structure for table `services`
#

CREATE TABLE `services` (
  `sid` tinyint(4) NOT NULL default '0',
  `sname` varchar(255) NOT NULL default '',
  `sfee` float(6,2) NOT NULL default '0.00',
  PRIMARY KEY  (`sid`)
) TYPE=MyISAM CHARSET=latin1;

#
# Dumping data for table `services`
#

INSERT INTO `services` VALUES (1, 'Accounting', '1500.00');
INSERT INTO `services` VALUES (2, 'Recruitment', '500.00');
INSERT INTO `services` VALUES (3, 'Data Management', '300.00');
INSERT INTO `services` VALUES (4, 'Administration', '500.00');
INSERT INTO `services` VALUES (5, 'Customer Support', '2500.00');
INSERT INTO `services` VALUES (6, 'Security', '600.00');
    
#
# Chapter 12
#

#
# Table structure for table `departments`
#

CREATE TABLE `departments` (
  `eid` tinyint(4) NOT NULL default '0',
  `dept` varchar(255) NOT NULL default ''
) TYPE=InnoDB;

#
# Table structure for table `employees`
#

CREATE TABLE `employees` (
  `eid` tinyint(4) NOT NULL auto_increment,
  `ename` varchar(255) NOT NULL default '',
  `enationality` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`eid`)
) TYPE=InnoDB AUTO_INCREMENT=3 ;

#
# Table structure for table `payroll`
#

CREATE TABLE `payroll` (
  `eid` tinyint(4) NOT NULL default '0',
  `pbasic` float(7,2) NOT NULL default '0.00',
  `pbonus` float(7,2) NOT NULL default '0.00'
) TYPE=InnoDB;
