#!/usr/bin/perl

# read in required modules
use DBI;
use CGI;

# initialize CGI object
$cgi = new CGI();

# print HTTP headers
print $cgi->header();

# check to see if article ID has been sent
if (!$cgi->param('aid'))
{
	print "Unable to find article ID, terminating...";	
	die;
}
else
{
	$aid = $cgi->param('aid');
}

# print page header
print $cgi->start_html;

# connect to database
my $dbh = DBI->connect("DBI:mysql:database=db1;host=localhost", "root", "", {'RaiseError' => 1});

# execute query
my $sth = $dbh->prepare("SELECT atitle, abody FROM articles WHERE aid='$aid'");
$sth->execute();

# if result available
# print article contents
# else print error
if ($sth->rows() > 0)
{
	$ref = $sth->fetchrow_hashref();
	print "<font face=\"Verdana, Arial\" size=\"4\" color=\"#66CC00\">\n";
	print $ref->{'atitle'}, "\n";
	print "</font>\n";
	print "<p>\n";
	print "<font face=\"Verdana, Arial\" size=\"2\" color=\"Black\">\n";
	print $ref->{'abody'}, "\n";
	print "</font>\n";
}
else
{
	print "Unable to retrieve article contents, terminating...";	
	die;
}

# close database connection
$sth->finish();
$dbh->disconnect();

# display comment tree
print "<hr>\n";
build_tree(0, $aid);
print "<hr>\n";

# print page footer
# with link to comment posting form
print <<EOF;
<font face="Verdana, Arial" size="2" color="Black">
<a href="post.cgi?aid=$aid">Comment</a> on this article.
</font>
EOF
print $cgi->end_html;

# this is a recursive function to build the comment tree
sub build_tree()
{
	# get starting comment ID and article ID
	# as input parameters
	$cid = shift;
	$aid = shift;

	# connect to database
	my $dbh = DBI->connect("DBI:mysql:database=db1;host=localhost", "root", "", {'RaiseError' => 1});

	# execute query
	my $sth = $dbh->prepare("SELECT cid, csubject FROM comments where aid = '$aid' AND creply = '$cid'");
	$sth->execute();

	# if result available
	# print comment subject line
	# else print message stating no comments
	if ($sth->rows() <= 0 && $cid == 0)
	{
	 	print "<font face=Verdana size=2 color=Black><b>No comments available</b></font>";
	 }
	 else
	 {
		# iterate over result set 	
		while($ref = $sth->fetchrow_hashref())
		{
			# print each comment as list item
			# recurse to build hierarchical tree 
			print "<ul>";
			print "<li><a href=\"details.cgi?cid=$ref->{'cid'}&aid=$aid\"><font face=Verdana size=2 color=Black><b>$ref->{'csubject'}</b></a>&nbsp;</li>\n";
			build_tree($ref->{'cid'}, $aid);
			print "</ul>";
		}
	 }
}
