<?php
// connect to database
try {
    $pdo = new PDO('mysql:dbname=test;host=localhost', 'root', '');
} catch (PDOException $e) {
    echo "Error: Could not connect. " . $e->getMessage();
}

// set error mode
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

try {
    // execute SELECT query
    $sql = "SELECT * FROM countries";
    $stmt = $pdo->query($sql);
    if ($stmt->rowCount() > 0) {
      // create a new DOM tree
      $doc = new DOMDocument('1.0');
      
      // create and attach root element <resultset> 
      $root = $doc->createElement('resultset');
      $resultset = $doc->appendChild($root);

      while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // loop over result set
        // set up <record> element for each row
        $record = $doc->createElement('record');
        $resultset->appendChild($record);
        
        foreach ($row as $name => $value) {
          // attach fields and values as <field>value</field>
          $field = $doc->createElement($name);
          $text = $doc->createTextNode($value);
          $record->appendChild($field);
          $field->appendChild($text);
        }
      }
    }
} catch (Exception $e) {
    echo "Error: Could not execute query \"$sql\". " . $e->getMessage();    
    unset($pdo);
}

// close connection
// output XML string
unset($pdo);
header('Content-Type: text/xml');
echo $doc->saveXML();  
?>
