<?php
// initialize new DOMDocument
$doc = new DOMDocument();

// disable whitespace-only text nodes
$doc->preserveWhiteSpace = false;

// read XML file
$doc->load('library.xml');

// get collection of <book> elements
// for each book
// retrieve and print 'genre' and 'rating' attributes
// output: 'The Shining \n Genre: horror \n Rating: 5 \n\n ...'
$books = $doc->getElementsByTagName('book');
foreach ($books as $book) {
  $title = $book->getElementsByTagName('title')->item(0)->nodeValue;
  $rating = $book->getAttribute('rating');
  $genre = $book->getAttribute('genre');
  echo "$title\n";
  echo "Genre: $genre\n";
  echo "Rating: $rating\n\n";
}
?>