<?php
// initialize new DOMDocument
$doc = new DOMDocument();

// disable whitespace-only text nodes
$doc->preserveWhiteSpace = false;

// read XML file
$doc->load('library.xml');

// get collection of <book> elements
// for each book
// retrieve and print all attributes
// output: 'The Shining \n id: 1 \n genre: horror \n rating: 5 \n\n ...'
$books = $doc->getElementsByTagName('book');
foreach ($books as $book) {
  $title = $book->getElementsByTagName('title')->item(0)->nodeValue;
  echo "$title\n";
  foreach ($book->attributes as $attr) {
    echo "$attr->name: $attr->value \n";
  }
  echo "\n";
}
?>