<?php
// initialize new DOMDocument
$doc = new DOMDocument();

// disable whitespace-only text nodes
$doc->preserveWhiteSpace = false;

// read XML file
$doc->load('library.xml');

// get collection of <book> elements
$books = $doc->getElementsByTagName('book');

// change the <title> element of the second <book>
$books->item(1)->getElementsByTagName('title')->item(0)->nodeValue = 'Invisible Prey';

// change the <author> element of the second <book>
$books->item(1)->getElementsByTagName('author')->item(0)->nodeValue = 'John Sandford';

// output new XML string
header('Content-Type: text/xml');
echo $doc->saveXML();
?>
