<?php
// initialize new DOMDocument
$doc = new DOMDocument();

// disable whitespace-only text nodes
$doc->preserveWhiteSpace = false;

// read XML file
$doc->load('address.xml');

// get root element
$root = $doc->firstChild;

// get text node 'UK'
echo "Country: " . $root->childNodes->item(3)->nodeValue . "\n";

// get text node 'Oxford'
echo "City: " . $root->childNodes->item(2)->childNodes->item(0)->nodeValue . "\n";

// get text node 'OX1 1BA'
echo "Postal code: " . $root->childNodes->item(2)->childNodes->item(1)->nodeValue . "\n";

// output: 'Country: UK \n City: Oxford \n Postal code: OX1 1BA'
?>
