<?php
// initialize new DOMDocument
$doc = new DOMDocument();

// disable whitespace-only text nodes
$doc->preserveWhiteSpace = false;

// read XML file
$doc->load('library.xml');

// get collection of <book> elements
// for each <book>, get the value of the <title> and <author> elements
// output: 'The Shining is written by Stephen King. \n ...'
$books = $doc->getElementsByTagName('book');
foreach ($books as $book) {
  $title = $book->getElementsByTagName('title')->item(0)->nodeValue;
  $author = $book->getElementsByTagName('author')->item(0)->nodeValue;
  echo  "$title is written by $author.\n";
}
?>
