<?php
// initialize new DOMDocument
$doc = new DOMDocument('1.0');

// create and attach root element <schedule> 
$root = $doc->createElement('schedule');
$schedule = $doc->appendChild($root);

// create and attach <course> element under <schedule>
$course = $doc->createElement('course');
$schedule->appendChild($course);

// create and attach <title> element under <course>
// add a value for the <title> element
$title = $doc->createElement('title');
$titleData = $doc->createTextNode('Macro-Economics');
$course->appendChild($title);
$title->appendChild($titleData);

// create and attach <teacher> element under <course>
// add a value for the <teacher> element
$teacher = $doc->createElement('teacher');
$teacherData = $doc->createTextNode('Professor Q. Draw');
$course->appendChild($teacher);
$teacher->appendChild($teacherData);

// create and attach <credits> element under <course>
// add a value for the <credits> element
$credits = $doc->createElement('credits');
$creditData = $doc->createTextNode('4');
$course->appendChild($credits);
$credits->appendChild($creditData);

// attach an attribute 'transferable' to the <credits> element
// set a value for the attribute
$transferable = $doc->createAttribute('transferable');
$credits->appendChild($transferable);
$credits->setAttribute('transferable', 'no');

// format XML output
$doc->formatOutput = true;

// output new XML string
header('Content-Type: text/xml');
echo $doc->saveXML();
?>
