<?php
// load XML file
$xml = simplexml_load_file('library.xml') or die ("Unable to load XML!");

// get the last book 'id'
$numBooks = count($xml->book);
$lastID = $xml->book[($numBooks-1)]{'id'};

// add a new <book> element
$book = $xml->addChild('book');

// get the 'id' attribute 
// for the new <book> element
// by incrementing $lastID by 1
$book->addAttribute('id', ($lastID+1));

// add <title>, <author> and <page> elements
$title = $book->addChild('title', 'Frommer\'s Italy 2007');
$author = $book->addChild('author', 'Various');
$page = $book->addChild('pages', 820);

// go back and add 'rating' and 'genre' attributes
$book->addAttribute('genre', 'travel');
$book->addAttribute('rating', 5);

// output new XML string
header('Content-Type: text/xml');
echo $xml->asXML();
?>
