<?php
// report all errors
error_reporting(E_ALL);

// use custom handler
set_error_handler('myHandler');

// create an output buffer
ob_start();

// define a custom handler
// which logs errors to the database
// then generates an error page
function myHandler($type, $msg, $file, $line, $context) {
  // log error to database
  $db = 'app.db';
  $pdo = new PDO("sqlite:$db");
  $msg = $pdo->quote($msg);
  $file = $pdo->quote($file);
  $line = $pdo->quote($line);
  $date = $pdo->quote(date('d-M-Y h:i:s', mktime()));
  $sql = "INSERT INTO errors (date, error, script, line) VALUES ($date, $msg, $file, $line)";
  $pdo->exec($sql);
  
  // reset and close the output buffer
  // generate a new error page
  ob_end_clean();
  $errorPage = '
  <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
     "DTD/xhtml1-transitional.dtd">
  <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
    <head>
      <title>Error Page</title>
    </head>
    <body>
      <div style="border:solid 1px black; padding:10px; width:50%; height:50%; margin:auto; top:0; bottom:0; right:0; left:0; position:absolute">
        <h2>Oops!</h2>
        This script encountered an internal error and was unable to execute. 
        The error has been logged and will be rectified as soon as possible.
        Until then, please return to the home page and select another activity.
      </div>
    </body>
  </html>';
  echo $errorPage;
  exit();
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
   "DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
  <head>
    <title>Project 10-1: Generating a Custom Error Page</title>
  </head>
  <body>
<?php
// output some page text
echo "<h1>Hello and welcome to this page.</h1>";

// generate warning (file not found)
include('missingfile.php');

// output some page text
echo "Goodbye.";

// dump output buffer
ob_end_flush();
?>
  </body>
</html>  
