<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
   "DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
  <head>
    <title>Project 11-1: Validating Form Input</title>
    <style type="text/css">
    div.error {
      color:red;
      font-weight: bolder;  
    }
    div.success {
      color:green;
      font-weight: bolder;  
    }
    </style>
  </head>
  <body>
    <h2>Project 11-1: Validating Form Input</h2>
    <h3 style="background-color: silver">Enter Book Details</h2>
<?php
    // display input validation error
    function getInputError($key, $errArray) {
      if (in_array($key, $errArray)) {
        return "<div class=\"error\">ERROR: Invalid data for field '$key'</div>";
      } else {
        return false;
      }
    }

    $inputErrors = array();
    $submitted = false;
    
    // if form submitted
    // validate form input
    if (isset($_POST['submit'])) {
      $submitted = true;
      $valid = array();
      
      // validate title
      if (!empty($_POST['title'])) {
        $valid['title'] = htmlentities(trim($_POST['title']));
      } else {
        $inputErrors[] = 'title';  
      } 
      
      // validate author name
      if (!empty($_POST['author']) && preg_match("/^[a-zA-Z\s.\-]+$/", $_POST['author'])) {
        $valid['author'] = htmlentities(trim($_POST['author']));
      } else {
        $inputErrors[] = 'author';  
      }
      
      // validate ISBN
      if (!empty($_POST['isbn']) && preg_match('/^(97(8|9))?\d{9}(\d|X)$/', $_POST['isbn'])) {
        $valid['isbn'] = htmlentities(trim($_POST['isbn']));
      } else {
        $inputErrors[] = 'isbn';  
      }
      
      // validate price
      if (!empty($_POST['price']) && is_numeric($_POST['price']) && $_POST['price'] > 0) {
        $valid['price'] = htmlentities(trim($_POST['price']));
      } else {
        $inputErrors[] = 'price';  
      }             
    }
    
    // if form not submitted
    // or if validation errors exist
    // (re)display form
    if (($submitted == true && count($inputErrors) > 0) || $submitted == false) { 
?>      
    <form method="post" action="books.php">      
      Title: <br />
      <input type="text" size="25" name="title" 
        value="<?php echo isset($_POST['title']) ? $_POST['title'] : '';?>" /><br/>
      <?php echo getInputError('title', $inputErrors); ?>
      <p>      
      Author: <br />
      <input type="text" size="25" name="author" 
        value="<?php echo isset($_POST['author']) ? $_POST['author'] : '';?>" /><br/>   
      <?php echo getInputError('author', $inputErrors); ?>
      <p>      
      ISBN: <br />
      <input type="text" size="25" name="isbn" 
        value="<?php echo isset($_POST['isbn']) ? $_POST['isbn'] : '';?>" /><br/>    
      <?php echo getInputError('isbn', $inputErrors); ?>
      <p>      
      Price: <br />
      <input type="text" size="6" name="price" 
        value="<?php echo isset($_POST['price']) ? $_POST['price'] : '';?>" /><br/>      
      <?php echo getInputError('price', $inputErrors); ?>
      <p>
      <input type="submit" name="submit" value="Submit" />      
    </form>
<?php
    // if form submitted with no errors
    // write the input to the database
    } else {      
      // open SQLite database file
      try {
         $pdo = new PDO('sqlite:books.db');
         $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
      } catch (PDOException $e) {
         die("ERROR: Could not connect: " . $e->getMessage());
      }
      
      // create and execute INSERT query
      try {
        $title = $pdo->quote($valid['title']);
        $author = $pdo->quote($valid['author']);
        $isbn = $pdo->quote($valid['isbn']);
        $price = $pdo->quote($valid['price']);
        $sql = "INSERT INTO books (title, author, isbn, price) VALUES ($title, $author, $isbn, $price)";
        $ret = $pdo->exec($sql);
        echo '<div class="success">SUCCESS: Record saved!</div>';
      } catch (Exception $e) {
        echo '<div class="error">ERROR: ' . $e->getMessage() . '</div>';        
      }
      
      // close connection
      unset($pdo);
    }
?>
  </body>
</html>
