<?
class RSSParser
{
    
    //
    // class variables
    //
    
    // holds name of element currently being parser 
    var $tag = "";

    // location variable indicating whether parser is within 
    // item or channel block
    var $location = 0;

    // array counter
    var $counter = 0;

    // name of RSS file
    var $file = "";
    
    // associative array for channel data
    var $channelData = array();
    
    // nested array of arrays for item data
    // every element of this array will represent 
      // one item in the channel 
    var $itemData = array();


    //
    // class methods
    //

    // set the name of the RSS file to parse
    // this is usually a local file
    // set it to a remote file only 
    // if your PHP build supports fopen() over HTTP
    function setRSS($file)
    {
        $this->file = $file;
    }


    // element handlers
    // these keep track of the element currently being parsed
    // and adjust $location and $tag accordingly
    function startElementHandler($parser, $name, $attributes)
    {
        $this->tag = $name;

        if ($name == "ITEM")
        {
            // if entering item block
            // set location variable to 1
            $this->location = 1;
        }
        else if ($name == "CHANNEL")
        {
            // if entering channel block
            // set location variable to 2
            $this->location = 2;
        }
    }
    
    function endElementHandler($parser, $name)
    {
        $this->tag = "";
    
        // if exiting channel or item block
        // reset location variable to 0
        if ($name == "ITEM")
        {
            $this->counter++;
            $this->location = 0;
        }
        else if ($name == "CHANNEL")
        {
            $this->location = 0;
        }
    }
    
    // character data handler
    // this function checks to see whether the parser is
    // currently reading channel or item information
    // and appends the information to the appropriate array
    function characterDataHandler($parser, $data)
    {
        $data = trim(htmlspecialchars($data));

        // only interested in these three elements...
        if ($this->tag == "TITLE" || $this->tag == "LINK" || $this->tag == "DESCRIPTION")
        {
            // if within an item block
            // add data to item array
            if ($this->location == 1)
            {
                $this->itemData[$this->counter][strtolower($this->tag)] .= $data;
            }
            else if ($this->location == 2)
            {
                // else add it to channel array
                $this->channelData[strtolower($this->tag)] .= $data;
            }
        }
    }    

    // data retrieval methods
    
    // this returns the array with channel information
    function getChannelData()
    {
        return $this->channelData;
    }

    // this returns the array with item information
    function getItemData()
    {
        return $this->itemData;
    }
    
    // all the work happens here
    
    // parse the specified RSS file
    // this populates the $channelData and $itemData arrays
    function parseRSS()
    {
        // create parser
        $this->xmlParser = xml_parser_create();
        
        // set object reference
        xml_set_object($this->xmlParser, $this);
        
        // configure parser behaviour
        xml_parser_set_option($this->xmlParser, XML_OPTION_CASE_FOLDING, TRUE);
        xml_parser_set_option($this->xmlParser, XML_OPTION_SKIP_WHITE, TRUE);

        // set up handlers
        xml_set_element_handler($this->xmlParser, "startElementHandler", "endElementHandler");
        xml_set_character_data_handler($this->xmlParser, "characterDataHandler");
    
        // read RSS file
        if (!($fp = fopen($this->file, "r"))) 
        {
              die("Could not read $this->file");
        }
        
        // begin parsing...
        while ($data = fread($fp, 2048)) 
        {
            if (!xml_parse($this->xmlParser, $data, feof($fp))) 
            {
                die("The following error occurred: " . xml_error_string(xml_get_error_code($this->xmlParser)));
            }
        }
        
        // destroy parser
        xml_parser_free($this->xmlParser);
    }

// end of class
}
?>
