<?php
// XML file
$xml_file = "/tmp/ch9.xml";

// parse document
if(!$doc = xmldocfile($xml_file))
{
     die("Error in XML document");
}

// get the root
$root = $doc->root();

// children of the root
$children = $root->children();
     
// start traversing the tree
search_and_replace($children, "Luke", "Crazy Dan");     

// all done, save the new tree to a file
// or display it if file write not possible
if (is_writable(dirname($xml_file)))
{
     $filename = dirname($xml_file) . "/_new_" . basename($xml_file);
     $fp = fopen($filename,"w+");
     fputs($fp,$doc->dumpmem());
     fclose($fp);
}
else
{
     echo $doc->dumpmem();
}

// this is a recursive function to traverse the DOM tree
// when it finds a text node, it will look for the search string and replace with
// the replacement string     
function search_and_replace($nodeCollection, $search, $replace)
{
     for ($x=0; $x<sizeof($nodeCollection); $x++)
     {

          if ($nodeCollection[$x]->type == XML_ELEMENT_NODE)
          {
                // if element, it may contain child text nodes
                // go one level deeper
                $nextCollection = $nodeCollection[$x]->children();
                search_and_replace($nextCollection, $search, $replace);
          }
          else if ($nodeCollection[$x]->type == XML_TEXT_NODE)
          {
                // if text node, perform replacement
                $str = str_replace($search, $replace, $nodeCollection[$x]->content);     
                // remember to write the value of the text node back to the tree!
                $nodeCollection[$x]->set_content($str);
          }
          
     }
}
?>
