<?php

// XML data
$xml_string = "<?xml version='1.0'?>
<sentence>
What a wonderful profusion of colors and smells in the market - <vegetable color='green'>cabbages</vegetable>, <vegetable color='red'>tomatoes</vegetable>, <fruit color='green'>apples</fruit>, <vegetable color='purple'>aubergines</vegetable>, <fruit color='yellow'>bananas</fruit>
</sentence>";

// parse it
if (!$doc = xmldoc($xml_string))
{
     die("Error in XML document");
}

// get the root node
$root = $doc->root();

// get its children
$children = $root->children();

// iterate through child list
for ($x=0; $x<sizeof($children); $x++)
{
     // if element node
     if ($children[$x]->type == XML_ELEMENT_NODE)
     {
          // get the text node under it
          $text = $children[$x]->children();
          $cdata = $text[0]->content;
             
          // check its attributes to see if "color" is present
          $attributes = $children[$x]->attributes();
               
          if (is_array($attributes) && ($index = is_color_attribute_present($attributes)))
          {
               // if it is, colorize the element content
               echo "<font color=" . $index . ">" . $cdata . "</font>";
          }
          else
          {
               // else print it as is
               echo $cdata;
          }
     }
     // if text node
      else if ($children[$x]->type == XML_TEXT_NODE)
      {
     // simply print the content
          echo $children[$x]->content;
     }
     
}

// function to iterate through attribute list
// and return the value of the "color" attribute if available
function is_color_attribute_present($attributeList)
{

     foreach($attributeList as $attrib)
     {
          if ($attrib->name == "color")
          {
               $color = $attrib->value;
               break;
          }
    }

    return $color;
}

?>
