<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- define a custom number format so that non-numbers are displayed as 0 -->
<xsl:decimal-format name="NaNFixFormat" NaN="0" zero-digit="0"/>

<!-- start -->
<xsl:template match="/">
      <html>
      <head>
      </head>
      <body>
      <table border="1" cellspacing="5" cellpadding="5">

      <!-- first row -->
      <tr>
      <td> </td>
      <!-- this returns a list of unique culture names, which are printed in the first row -->
      <xsl:for-each select="//culture[not(.=preceding::culture)]">
      <td><xsl:value-of select="."/></td>
      </xsl:for-each>      
      </tr>

      <!-- next, we need a list of available temperatures, printed as the first column (so put into a loop) -->
      <xsl:for-each select="//temperature[not(.=preceding::temperature)]">
      <tr>
      <td><xsl:value-of select="."/></td>
      <!-- assign the current temperature value to $t-->
      <xsl:variable name="t" select="." />

                  <!-- iterate through the culture list for this temperature value -->
                  <xsl:for-each select="//culture[not(.=preceding::culture)]">
                  
                  <!-- assign the current culture name to $c-->
                  <xsl:variable name="c" select="." />
                  
                  <!-- average all readings corresponding to the intersection ($t, $c), format and display -->
                  <td><xsl:value-of select="format-number(sum(//record[culture=$c and temperature=$t]/reading) div count(//record[culture=$c and temperature=$t]/reading), '0', 'NaNFixFormat')"/></td>
                  </xsl:for-each>      
                  
      </tr>
      <!-- iterate to next row-->
      </xsl:for-each>      
      </table>
      </body>
      </html>
</xsl:template>

</xsl:stylesheet>
