<html>
<head>
<basefont face="Arial">
</head>

<body>


<?php
if(!$_POST['submit'])
{
?>
      <form action="<? echo $_SERVER['PHP_SELF']; ?>" method="POST">
      <b>City code:</b>
      <br>
      <input type="text" name="city" size="4" maxlength="3">
      <p>
      <b>Data format:</b>
      <br>
      <input type="Radio" name="format" value="avg" checked>Average only
      <br>
      <input type="radio" name="format" value="raw">Raw data
      <p>
      <input type="submit" name="submit" value="Go!">
      </form>


<?php
}
else
{

      // where is the RPC server?
      $server = "weather.domain.com";
      $url = "/rpc/server.php";
      $port = 80;

      // RPC arguments
      $city = strtoupper($_POST['city']);
      $params = array("city" => $city, "format" => $_POST['format']);

      // encode XML-RPC request
      $request = xmlrpc_encode_request("getWeatherData", $params, array("verbosity" => "no_white_space"));

      // open socket
      $fp = fsockopen($server, $port);

      if(!$fp)
      {
            echo "Could not open socket";
      }
      else
      {
            // create POST data string
            $post_data = "POST $url HTTP/1.0\r\nUser-Agent: PHP-RPC Client\r\nContent-Type: text/xml\r\nContent-Length: " . strlen($request) . "\r\n\r\n" . $request;
         
            // send POST data
            fwrite($fp, $post_data);
      
            // read the response
            $post_response = fread($fp, 14096);

            // close the socket
            fclose($fp);
      }

      // strip out HTTP headers in response
      // look for <?xml and get everything from there to the end of the response
      $response = substr($post_response, strpos($post_response, "<?xml"));

      // decode response
      $output = xmlrpc_decode($response);

      // more stringent error checks would be good here
      if(is_array($output))
      {
            // check to see if a fault was returned
            if (!isset($output[0]["faultCode"]))
            {
                  // no? this means valid data was returned
                  // format and display
                  if ($output["format"] == "avg")
                  {
                        echo "Average temperature reading for city $city is " . $output["data"] . " (based on three readings)";
                  }
                  else if ($output["format"] == "raw")
                  {
                        echo "Last three temperature readings for city $city (8-hour intervals) are:<br><ul>";
                        echo "<li>" . $output["data"][0];
                        echo "<li>" . $output["data"][1];
                        echo "<li>" . $output["data"][2];
                        echo "</ul>";
                  }
            }
            else
            {
                  // a fault occurred
                  // format and display fault information
                  echo "The following fault occurred:<br>";
                  echo $output[0]["faultString"] . " (fault code " . $output[0]["faultCode"] . ")";       
            }
      }
      else
      {
            // no array returned
            echo "Unrecognized response from server";
      }

}
?>
</body>
</html>
