<?php

include("utils.php");

$request = $HTTP_RAW_POST_DATA;

// create server
$rpc_server = xmlrpc_server_create() or die("Could not create RPC server");

// register methods
xmlrpc_server_register_method($rpc_server, "getTotalPOP3Messages", "getTotalPOP3Messages") or die("Could not register method");

// call method
$response = xmlrpc_server_call_method($rpc_server, $request, NULL, array("verbosity" => "no_white_space", "version" => "soap 1.1"));
   
// print response
echo $response;

// clean up
xmlrpc_server_destroy($rpc_server);

// function to return number of messages
function getTotalPOP3Messages($method, $args, $add_args)
{
      
      // check to see if the server supports POP3
      // you may need to recompile your PHP build
      // to enable this support
      if (function_exists('imap_open'))
      {
            // open connection to mail server
            $inbox = imap_open ("{". $args[0]["pop_host"] . "/pop3:110}", $args[0]["pop_user"], $args[0]["pop_pass"]);

            if ($inbox)
            {
                  // get number of messages
                  $total = imap_num_msg($inbox);
                  imap_close($inbox);
                  return $total;
            }
            else
            {
                  return xu_fault_code(2, "Could not connect to POP3 server");
            }
      }
      else
      {
            return xu_fault_code(1, "POP3 support not available on RPC server");
      }
}
?>
