<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- set up page template -->
<xsl:template match="/">
      <html>
      <head>
      <basefont face="Arial" />
      </head>
      <body>
      <table border="1" cellspacing="0" cellpadding="5">
      <xsl:apply-templates select="//structure" />
      <xsl:apply-templates select="//data" />
      </table>
      </body>
      </html>
</xsl:template>

<!-- read structure data, set up first row of table -->
<xsl:template match="//structure">
      <tr>
      <!-- iterate through field list, print field information -->
      <xsl:for-each select="field">
      <td bgcolor="silver"><font face="Arial" size="-1"><b><xsl:value-of select="name" /></b>  <i>(<xsl:value-of select="type" />, <xsl:value-of select="length" />)</i></font></td>  
      </xsl:for-each>
      </tr>
</xsl:template>

<!-- read records -->
<xsl:template match="//data">
      <!-- iterate through records -->
      <xsl:for-each select="record">
      <tr>
                  <!-- iterate through fields of each record -->
                  <xsl:for-each select="item">
                  <td><font face="Arial" size="-1"><xsl:value-of select="." /></font>&#160;</td>
                  </xsl:for-each>
      </tr>
      </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
