<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- set up page template -->
<xsl:template match="/">
      <html>
      <head>
      <basefont face="Arial" />
      </head>
      <body>
      <h3>My CD Collection</h3>
      <table border="1" cellspacing="0" cellpadding="5">
      <tr>
      <td align="center">Artist</td>
      <td align="center">Title</td>
      <td align="center">Track list</td>
      </tr>
      <xsl:apply-templates />
      </table>
      </body>
      </html>
</xsl:template>

<!-- look for CDs -->
<xsl:template match="//cd">
      <tr>
      <td align="center" valign="top"><xsl:value-of select="artist" /></td>
      <td align="center" valign="top"><xsl:value-of select="title" /></td>
      <td align="left" valign="top">
            <ol>
            <!-- iterate through track list, print each <track> element as list item -->
            <xsl:for-each select="tracks/track">
            <li><xsl:value-of select="." /></li>
            </xsl:for-each>
            </ol>
      &#160;</td>
      </tr>
</xsl:template>
</xsl:stylesheet>
