<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- output as text, strip whitespace -->
<xsl:output method="text" indent="no" />
<xsl:strip-space elements="*"/>

<!-- look for the table node  -->
<xsl:template match="/table" >
      <!-- iterate through each record -->
      <xsl:for-each select="record">
            
            <!-- get the table name -->
            <xsl:text>INSERT INTO </xsl:text>
            <xsl:value-of select="/table/@name" />
            <xsl:text>(</xsl:text>
            
            <!-- iterate through child elements and get field names -->
            <xsl:for-each select="child::*">
                  <xsl:value-of select="name()" />
                  <xsl:if test="position() != last()">, </xsl:if>
            </xsl:for-each>
      
            <xsl:text>) VALUES(</xsl:text>
            
            <!-- iterate through child elements and get values -->
            <xsl:for-each select="child::*">
                  <xsl:text>"</xsl:text>
                  <xsl:value-of select="." />
                  <xsl:text>"</xsl:text>
                  <xsl:if test="position() != last()">
                        <xsl:text>,</xsl:text>
                  </xsl:if>
            </xsl:for-each>

          <xsl:text>);</xsl:text>

      </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
