<?php

// include class definitions
include("class.soap_client.php");
include("class.soap_server.php");

// instantiate a server object
$server = new soap_server;

// uncomment next line to see server debug messages
// $server->debug_flag = true;

/*
the add_to_map() method adds a procedure to the server's list 
of exposed public methods

the second and third argument specify the data type of the input (arguments) to, 
and output (return values) from, the procedure respectively.
*/ 

$server->add_to_map("getTotalPOP3Messages", array("SOAPStruct"), array("int"));

/*
the service() function services the SOAP request
and sends a SOAP response back to the client
*/

$server->service($HTTP_RAW_POST_DATA);

// function to return number of messages
function getTotalPOP3Messages($struct)
{

      // make sure the server supports POP3
      // if you're using PHP, you may need to recompile your build
      // to enable this support
      $inbox = imap_open ("{". $struct["pop_host"] . "/pop3:110}", $struct["pop_user"], $struct["pop_pass"]);

      // if connection successfully opened
      if ($inbox)
      {
            // get number of messages
            $total = imap_num_msg($inbox);
            imap_close($inbox);
            return $total; 
      }
      else
      {
            // else generate a SOAP fault
            $params = array("faultcode" => "75", "faultstring" => "No connection available", "detail" => "Could not connect to POP3 server");
            $faultmsg  = new soapmsg("Fault", $params, "http://schemas.xmlsoap.org/soap/envelope/");
            return $faultmsg;
      }

}

?>
