<html>
<head>
<basefont face="Arial">
</head>
<body bgcolor="white">
<?php

// include class definition
require("XPath.class.php");

// XML file
$xml_file = "data.xml";

// create arrays to hold culture/temperature list 
$cultures = array();
$temperatures = array();

// create XPath object
$xpath = new XPath($xml_file);

// get a list of "culture" nodes
$nodeset = $xpath->match("//culture");

// ...and create an array containing 
// the names of all available cultures
for ($x=0; $x<sizeof($nodeset); $x++)
{
     $cultures[] = $xpath->getData($nodeset[$x]);
}

// strip out duplicates
$cultures = array_unique($cultures);

// do the same thing for temperature points
$nodeset = $xpath->match("//temperature");

for ($x=0; $x<sizeof($nodeset); $x++)
{
     $temperatures[] = $xpath->getData($nodeset[$x]);
}

$temperatures = array_unique($temperatures);

// sort both arrays
natsort($temperatures);
natsort($cultures);
?>
<table border="1" cellspacing="5" cellpadding="5">

<tr>
<td>&nbsp;</td>
<?php
// first row of table, print culture names
foreach($cultures as $c)
{
     echo "<td>$c</td>";
}
?>
</tr>

<?php     
foreach($temperatures as $t)
{
     // create as many rows as there are temperature points
     echo "<tr>";
     echo "<td>$t</td>";

     // for each intersection (culture, temperature)
     // print average of available readings
     foreach($cultures as $c)
     {
          echo "<td>" . intersection($t, $c) . "</td>";
     }
     
     echo "</tr>";
}
?>

</table>

<?php
// this function collects all readings for
// a particular culture/temperature
// totals them and averages them
function intersection($temperature, $culture)
{
      // get a reference to the XPath object
      global $xpath;

      // set up variables to hold total and frequency
      $total = 0;
      $count = 0;

      // get a list of "reading" nodes
      // for records with culture c and temperature t
      $nodeset = $xpath->match("//record[culture='" . $culture . "' and temperature='" . $temperature . "']/reading");

      // iterate through nodeset
      // add the readings
      foreach ($nodeset as $reading)
      {
            $total += $xpath->getData($reading);
            $count++;
      }

      // and then average them
      if ($count > 0)
      {
            return $total/$count;
      }

      return 0;
}

?>
</body>
</html>
