<?php

// XML data 
$xml_file = "links.xml";

// read XML file
if (!($fp = fopen($xml_file, "r"))) 
{
      die("File I/O error: $xml_file");
}

// create string containing XML data
while ($chunk = fread($fp, 4096)) 
{
      $data .= $chunk;
}

// initialize parser
$xml_parser = xml_parser_create();

// turn off whitespace processing
xml_parser_set_option($xml_parser,XML_OPTION_SKIP_WHITE,1);

// read file
if (!xml_parse_into_struct($xml_parser, $data, $elementArray, $frequencyArray)) 
{
      die("XML parser error: " . xml_error_string(xml_get_error_code($xml_parser)));
}

// all done, clean up!
xml_parser_free($xml_parser);

// create array to hold URLs
$urls = array();

// look up $frequencyArray for <url> element
// this element is itself an array, so iterate through it
foreach($frequencyArray["URL"] as $element)
{
      // for each value found, look up $elementsArray and retrieve the value
      // add this to the URLs array
      $urls[] = $elementArray[$element]["value"];
}

print_r($urls);  
?>
