<html>
<head>
<basefont face="Arial">
</head>
<body bgcolor="white">
<?php

// XML file
$xml_file = "data.xml";

// parse document
$doc = xmldocfile($xml_file) or die("Could not read file!");

// create arrays to hold culture/temperature list 
$cultures = array();
$temperatures = array();

// create XPath context
$xpath = $doc->xpath_new_context();

// get a list of "culture" nodes
$obj = $xpath->xpath_eval("//culture");
$nodeset = $obj->nodeset;

// ...and create an array containing 
// the names of all available cultures
for ($x=0; $x<sizeof($nodeset); $x++)
{
     $children = $nodeset[$x]->children();
     $cultures[] = $children[0]->content;
}

// strip out duplicates
$cultures = array_unique($cultures);

// do the same thing for temperature points
$obj = $xpath->xpath_eval("//temperature");
$nodeset = $obj->nodeset;

for ($x=0; $x<sizeof($nodeset); $x++)
{
     $children = $nodeset[$x]->children();
     $temperatures[] = $children[0]->content;
}

$temperatures = array_unique($temperatures);

// sort both arrays
natsort($temperatures);
natsort($cultures);
?>
<table border="1" cellspacing="5" cellpadding="5">

<tr>
     <td>&nbsp;</td>
<?php
// first row of table, print culture names
foreach($cultures as $c)
{
      echo "<td>$c</td>";
}
?>
</tr>

<?php     
foreach($temperatures as $t)
{
     // create as many rows as there are temperature points
     echo "<tr>";
     echo "<td>$t</td>";

    // for each intersection (culture, temperature)
    // print average of available readings
    foreach($cultures as $c)
    {
          echo "<td>" . intersection($t, $c) . "</td>";
    }
     
     echo "</tr>";
}
?>

</table>

<?php
// this function collects all readings for
// a particular culture/temperature
// totals them and averages them
function intersection($temperature, $culture)
{
      // get a reference to the XPath context
      global $xpath;
      
      // set up variables to hold total and frequency
      $total = 0;
      $count=0;
      
      // get a list of "reading" nodes
      // for records with culture c and temperature t
      $obj = $xpath->xpath_eval("//record[culture='" . $culture . "' and temperature='" . $temperature . "']/reading");
      
      // if XPath evaluation successful
      if ($obj) 
      { 
            $nodeset = $obj->nodeset; 
            
            // iterate through nodeset
            if (is_array($nodeset))
            {
            // add the readings
               foreach ($nodeset as $reading)
               {
                     $children = $reading->children();
                     $total += $children[0]->content;
                     $count++;
               }
           }
      }
      
      // and then average them
      if ($count > 0)
      {
           return $total/$count;
      }

      return 0;
}
      
?>
</body>
</html>
