<?php

// XML data
$xml_string = "<?xml version='1.0'?>
<sentence>
What a wonderful profusion of colors and smells in the market - <vegetable color='green'>cabbages</vegetable>, <vegetable color='red'>tomatoes</vegetable>, <fruit color='green'>apples</fruit>, <vegetable color='purple'>aubergines</vegetable>, <fruit color='yellow'>bananas</fruit>
</sentence>";

// parse it
if (!$doc = xmldoc($xml_string))
{
     die("Error in XML document");
}

// get the root node
$root = $doc->root();

// get its children
$children = $root->children();

// iterate through child list
for ($x=0; $x<sizeof($children); $x++)
{
     // if element node
      if ($children[$x]->type == XML_ELEMENT_NODE)
      {
          // get the text node under it
            $text = $children[$x]->children();
            $cdata = $text[0]->content;
     
          // check to see if element contains the "color" attribute
          if ($children[$x]->get_attribute("color"))
          {
               // "color" attribute is present, colorize text
               echo "<font color=" . $children[$x]->get_attribute("color") . ">" . $cdata . "</font>";
          }
           else
           {
                // otherwise just print the text as is
                echo $cdata;
          }
     }
      // if text node
      else if ($children[$x]->type == XML_TEXT_NODE)
      {
          // print content as is     
          echo $children[$x]->content;
     }
}

?>
