<?php

// alter this to see other formats
$format = "csv";

// set the filenames
$xml_file = "ptable.xml";

// pick the XSLT sheet based on the $format variable
$xslt_file = "ptable_" . $format . ".xsl";

// set the name for the output file
$out_file = "/www/ptable." . $format;

// create the XSLT processor
$xp = xslt_create() or die("Could not create XSLT processor");

// log messages
xslt_set_log($xp, "/tmp/xslt.log");

// define the error handler
xslt_set_error_handler($xp, "errHandler"); 

// process the files and write the output to $out_file
if(xslt_process($xp, $xml_file, $xslt_file, $out_file))
{
      echo "Success!";
}

// free the resources occupied by the handler
xslt_free($xp);

// custom error handler
function errHandler($processor, $level, $ecode, $einfo)
{
      echo "<html><head></head><body>Something bad just happened. Here's some more information: <br>"; 

      // iterate through error array
      while(list($key, $value) = each($einfo))
      {
            echo "$key --> $value <br>"; 
      }

echo "</body></html>";	
}

?>
