<?php

// set the filenames
$xml_file = "list.xml";
$xslt_file = "list.xsl";

// create the XSLT processor
$xp = xslt_create() or die("Could not create XSLT processor");

// set an error handler
xslt_set_error_handler($xp, "customErrorHandler");

// process the two files to get the desired output
$result = xslt_process($xp, $xml_file, $xslt_file);

// print output
echo $result;

// free the resources occupied by the handler
xslt_free($xp);

// custom error handler
function customErrorHandler($processor, $level, $ecode, $einfo)
{
      echo "<html><head></head><body>Something bad just happened. Here's some more information: <br>"; 

      // iterate through error array
      while(list($key, $value) = each($einfo))
      {
            echo "$key --> $value <br>"; 
      }

echo "</body></html>";
}

?>
