<?php

// IMPORTANT! This script should not be run via your Web server!
// You will need to run it from the command line, 
// or as a service from inetd.conf

// set up some socket parameters
$ip = "127.0.0.1";
$port = 7890;

// area to look for updated files
$repository = "/tmp/updates/";


// start with socket creation
// get a handler
if (($socket = socket_create (AF_INET, SOCK_STREAM, 0)) < 0) 
{
      // this is fairly primitive error handling
      echo "Could not create socket\n";
}

// bind to the port
if (($ret = socket_bind ($socket, $ip, $port)) < 0) 
{
      echo "Could not bind to socket\n";
}

// start listening for connections
if (($ret = socket_listen ($socket, 7)) < 0) 
{
      echo "Could not create socket listener\n";
}

// if incoming connection, accept and spawn another socket 
// for data transfer
if (($child = socket_accept($socket)) < 0) 
{
      echo "Could not accept incoming connection\n";
}
        
if (!$input = socket_read ($child, 2)) 
{
      echo "Could not read input\n";
}
else 
{
      // at this stage, GCorp might want to perform authentication
      // using the input received by the client

      // assuming authentication succeeds...
      
      // look in the updates directory
      $dir = opendir($repository);
      while($file = readdir($dir))
      {
            // omit the "." and ".." directories
            if($file != "." && $file != "..")
            {
                  $info = explode("-", $file);
                  // create an array of associative arrays, one for each file found
                  // each associative array has the keys "name", "version" and "size"
                  $filelist[] = array("name" => $info[0], "version" => $info[1], "size" => filesize($repository . $file));
            }
      }
      closedir($dir);

      // serialize the array
      $output = wddx_serialize_value($filelist);

      // and send it to the client
      if(socket_write ($child, $output, strlen ($output)) < 0)
      {
            echo "Could not write WDDX packet";
      }

      // clean up
      socket_close ($child);
}
socket_close ($socket);
?>
