<?php


// IMPORTANT!  This script should not be run via your Web server!
// You will need to run it manually from the command line, or via crontab

// set up some socket parameters
// this is the IP address of the socket server
$ip = "234.56.789.1";
$port = 7890;

// open a socket connection
$socket = fsockopen($ip, $port);

if (!$socket)
{
      echo "Could not open connection\n";
}
else
{
      // send a carriage return
      fwrite($socket, "\n");
      $packet = fgets($socket, 4096);
      // get and deserialize list of server packages
      $remote_packages = wddx_deserialize($packet);
      // close the socket
      fclose($socket);
      
      // make sure that the deserialized packet is an array
      if(!is_array($remote_packages))
      {
            $message= "Bad/unsupported data format received\n";
      }
      else
      {
            // now, start processing the received data
            for ($x=0; $x<sizeof($remote_packages); $x++)
            {
                  // for each item in the array
                  // check to see if a corresponding package is installed on the local system
                  $local_package = exec("rpm -qa | grep " . $remote_packages[$x]['name']);

                  // not there? that means it's a new package
                  // dump it into the $new_packages[] array
                  if ($local_package == "")
                  {
                        $new_packages[] = $remote_packages[$x];
                  }
                  else
                  {
                        // present? check version
                        // if a new version is available, 
                        // dump it into the $updated_packages[] array
                        $arr = explode("-", $local_package);
                        if ($arr[1] < $remote_packages[$x]['version'])
                        {
                              $updated_packages[] = $remote_packages[$x];
                        }
                  }
            }

            // finally, put together a notification for the sysop
            // list of updates, with file size and version

            // an option here might be to initiate an automatic
            // download of the updates
            // RPM can be used to auto-install the downloaded updates
            if (sizeof($updated_packages) > 0)
            {
                  $message .= "The following updates are available on our server:\n";
                  for ($x=0; $x<sizeof($updated_packages); $x++)
                  {
                        $message .= "Package: ". $updated_packages[$x]['name'] . "\n";
                        $message .= "Version: " . $updated_packages[$x]['version'] . "\n";
                        $message .= "Size: " . $updated_packages[$x]['size'] . " bytes\n\n";
                  }
            }

            // ...and list of new packages, with file size and version
            if (sizeof($new_packages) > 0)
            {
                  $message .= "The following new packages have been added to our server (may require purchase):\n";
                  for ($x=0; $x<sizeof($new_packages); $x++)
                  {
                        $message .= "Package: ". $new_packages[$x]['name'] . "\n";
                        $message .= "Version: " . $new_packages[$x]['version'] . "\n";
                        $message .= "Size: " . $new_packages[$x]['size'] . " bytes\n\n";
                  }
            }

            // mail it out
            if(mail("root@localhost", "GCorp package updates for this week", $message))
            {
                  echo "Operation successfully completed";
            }
            else
            {
                  echo "Error processing mail message";
            }
      }
}
?>
