<?php

// create server
$rpc_server = xmlrpc_server_create() or die("Could not create RPC server");

// register methods
xmlrpc_server_register_method($rpc_server, "getRandomQuote", "phpGetRandomQuote") or die("Could not register method");   

// function to run when introspection request comes through
xmlrpc_server_register_introspection_callback($rpc_server, "generateIntrospectionData");

// generate an XML-RPC request for system.methodHelp
// this would normally come from an RPC client
$request = xmlrpc_encode_request("system.methodHelp", "getRandomQuote");

// call method
$response = xmlrpc_server_call_method($rpc_server, $request, NULL, array("version" => "xml"));
   
// print response
echo $response;
   
// clean up
xmlrpc_server_destroy($rpc_server);


// function to auto-generate documentation for procedures
// (introspection)
function generateIntrospectionData()
{
   $data = <<< END
<?xml version="1.0"?>
   <introspection version="1.0">
      <methodList>
         <methodDescription name="getRandomQuote">
            <author>Vikram Vaswani</author>
            <purpose>Retrieves a random quote by the specified author</purpose>
            <version>1.0</version>
            <signatures>
         <signature>
                  <params>
                      <value type="string" name="author">The name of the quote author</value>
                  </params>
                  <returns>
                      <value type="string" name="quote">A quote by the specified author</value>
                  </returns>
               </signature>
            </signatures>
            <errors>
            <item>Returns fault code 2 if no quotes by the specified author are available</item>
            </errors>
            <notes />
            <bugs/>
            <todo/>
         </methodDescription>
      </methodList>
   </introspection>
END;

   return $data;

}

function phpGetRandomQuote($method, $args, $add_args)
{
     // code snipped out
}

?>
