<?php
// include class definitions
include("xmlrpc.inc");
include("xmlrpcs.inc");

// create server object
// the object constructor is used to map public procedure names to internal function names
$server = new xmlrpc_server(array("getWeatherData" => array("function" => "phpWeather")));

// function to retrieve weather data 
// and return it in requested format (raw or average)
function phpWeather($params)
{
      // get reference to associative array passed to server by client
      $struct = $params->getParam(0);

      // get value of "city" key
      // the structmem() method returns a reference to a particular key of the array
      // the scalarval() method extracts the corresponding value
      $member = $struct->structmem("city");
      $city = $member->scalarval();

      // get value of "format" key
      $member = $struct->structmem("format");
      $format = $member->scalarval();
      
      // initialize error variables
      $error_msg = "";
      $error_code = 0;

      if (!$city)
      {
            // no city code available
            // set error flag
            $error_msg = "Missing city code";
            $error_code = 998;
      }
      else
      {
            // open connection to database
            $connection = mysql_connect("localhost", "rpc_agent", "secret") or $error = "Unable to connect to database";
            mysql_select_db("weather_db") or $error = "Unable to select database";
            
            // get data
            $query = "SELECT t1, t2, t3 FROM weather WHERE city = '" . $city . "'";
            $result = mysql_query($query) or $error = "Error in query: $query. " . mysql_error();
      
            // if a result is returned
            if (mysql_num_rows($result) > 0)
            {
            // get column values
                  list($t1, $t2, $t3) = mysql_fetch_row($result);
                  
                  // close database connection
                  mysql_close($connection);
            }
            else
            {
                  // set error flag
                  $error_msg = "No data available for that city";
                  $error_code = 999;
            }
      }
      
      // if error flag set
      if ($error_msg)
      {
            // return an XML-RPC fault as an xmlrpcresp object
            return new xmlrpcresp(0, $error_code, $error_msg);
      }
      else
      {
            // process data depending on requested output format
            if ($format == "raw")
            {
                  // return raw data  as associative 
                  // array ("format" => $format, "data" = array($t1, $t2, $t3))

                  // note that the xmlrpcresp object is constructed
                  // from a collection of xmlrpcval objects
                  $data = array(new xmlrpcval($t1, "int"), new xmlrpcval($t2, "int"), new xmlrpcval($t3, "int"));
                  $result = new xmlrpcval(array("format" => new xmlrpcval($format, "string"), "data" => new xmlrpcval($data, "array")), "struct");
                  return new xmlrpcresp($result);

            }
            else if ($format == "avg")
            {
                  // total and average readings
                  $total = $t1 + $t2 + $t3;
                  
                  // do this to avoid division by zero errors
                  if ($total != 0)
                  {
                        $avg = $total/3;
                  }
                  else
                  {
                        $avg = 0;
                  }
                  
                  // return average as associative array ("format" => $format, "data" = $avg)
                  $result = new xmlrpcval(array("format" => new xmlrpcval($format, "string"), "data" => new xmlrpcval($avg, "int")), "struct");
                  return new xmlrpcresp($result);

            }
      }
}

?>
