<?php
class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{
  protected function _initDoctrine()
  {
      require_once 'Doctrine/Doctrine.php';
      $this->getApplication()
           ->getAutoloader()
           ->pushAutoloader(array('Doctrine', 'autoload'), 'Doctrine');

      $manager = Doctrine_Manager::getInstance();
      $manager->setAttribute(
          Doctrine::ATTR_MODEL_LOADING,
          Doctrine::MODEL_LOADING_CONSERVATIVE
      );

      $config = $this->getOption('doctrine');
      $conn = Doctrine_Manager::connection($config['dsn'], 'doctrine');
      return $conn;
  }  
    
  protected function _initLocale()
  {               
    $session = new Zend_Session_Namespace('square.l10n');
    if ($session->locale) {
      $locale = new Zend_Locale($session->locale);                 
    } 
    
    if ($locale === null) {
      try {
        $locale = new Zend_Locale('browser'); 
      } catch (Zend_Locale_Exception $e) {
        $locale = new Zend_Locale('en_GB');               
      } 
    }
      
    $registry = Zend_Registry::getInstance();
    $registry->set('Zend_Locale', $locale); 
  }


  protected function _initTranslate()
  {                         
    $translate = new Zend_Translate('array', APPLICATION_PATH . '/../languages/', 
      null, array('scan' => Zend_Translate::LOCALE_FILENAME, 'disableNotices' => 1));
    $registry = Zend_Registry::getInstance();
    $registry->set('Zend_Translate', $translate); 
  }

  protected function _initRoutes()
  {
    $front = Zend_Controller_Front::getInstance();
    $router = $front->getRouter();
    $restRoute = new Zend_Rest_Route($front, array(), array('api'));
    $router->addRoute('api', $restRoute);  
  }
        
}

